// Line 71
jQuery = function( selector, context ) {
	// The jQuery object is actually just the init constructor 'enhanced'
	// Need init if jQuery is called (just allow error to be thrown if not included)
	return new jQuery.fn.init( selector, context );
};

// Line 2827
init = jQuery.fn.init = function( selector, context ) {
	/* 11 lines of code */
	// Handle HTML strings
	if ( typeof selector === "string" ) {
		if ( selector[ 0 ] === "<" &&
			selector[ selector.length - 1 ] === ">" &&
			selector.length >= 3 ) {

			// Assume that strings that start and end with <> are HTML and skip the regex check
			match = [ null, selector, null ];

		} /*...*/

		// Match html or make sure no context is specified for #id
		if ( match && ( match[ 1 ] || !context ) ) {

			// HANDLE: $(html) -> $(array)
			if ( match[ 1 ] ) {
				/* 4 lines of code */
				jQuery.merge( this, jQuery.parseHTML(
					match[ 1 ],
					context && context.nodeType ? context.ownerDocument || context : document,
					true
				) );
				/* 16 lines of code */
				return this;
			} /*...*/
		} /*...*/
	} /*...*/
};

// Line 4304
function buildFragment( elems, context, scripts, selection, ignored ) {
	var /**/ fragment = context.createDocumentFragment()
	/* 4 lines of code */;
	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {
			/* 8 lines of code */
			/**/ if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );
				/* 21 lines of code */
			}
		}
	}
	/* 36 lines of code */
	return fragment;
}

// Line 9365
// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	/* 17 lines of code */
	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[ 1 ] ) ];
	}

	parsed = buildFragment( [ data ], context, scripts );
	/* 5 lines of code */
	return jQuery.merge( [], parsed.childNodes );
};
